require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

closed = false;

shadowoffset = 4;

function GotoNextLevel()
    if(GetCurrentGameMode() == 0) then
        if(GetConfig("firstpeek") == "1" and GetCurrentLevel() > 20 and GetHighestComplete() >= 20) then
            CloseWindow();
            PopModal("game_window");
            DoModal("scripts/endgame.lua");
        elseif(GetCurrentLevel() > 60 and GetHighestComplete() >= 60) then
            CloseWindow();
            PopModal("game_window");
            DoModal("scripts/endgame.lua");
        else
            --if(GetHighestComplete() > 0 and GetHighestComplete() + 1 == GetCurrentLevel() and rem(GetCurrentLevel(), 10) == 1) then
                --SetManagedValue("do_map_transition", 1, false);
            if( GetManagedInt( "do_map_transition", 0 ) == 1 ) then    
                SwapToModal( "scripts/worldmap.lua" );
            else
                DisplayDialog { "scripts/loading.lua", isFirst=false };
                CloseWindow();
            end
        end
    else
        --QuitToMainMenu();
        DisplayDialog { "scripts/loading.lua", isFirst=false };
        CloseWindow();
    end
end

MakeDialog
{
	name = "endlevel",
	
	VTintWindow{
	    x = 0, y = 0, w = 800, h = 600,
	    color = Color(0,0,0,160),
	    fade = true,
	},
	RBounceWindow {
	    name = "reciept_window",
	    w = 800,
	    h = 600,
	    x = 0, y = 600,
	    targetposx = 0, targetposy = 0,
	    bouncelen = 400, bouncefunc = "sincx",
	    alpha = true,
	    
	    Bitmap{
	        image = "ui/endlevel/background",
	        mask = "ui/endlevel/background.mask",
	        x = 59, 
	        y = 58,
	    },
	    --------------------------------- Today's Results
		Text{
			font = Prelevel_TitleShadowFont,
			x = 168 + 2, y = 74 + 2,
			w = 468, h = 58,
			flags = kHAlignCenter + kVAlignCenter,
			label = "endlevel_title",
		},
		---------shadow
		Text{
			font = Prelevel_TitleFont,
			x = 168, y = 74,
			w = 468, h = 58,
			flags = kHAlignCenter + kVAlignCenter,
			label = "endlevel_title",
		},
		---------------------------------- Data
	    Text {
	        x = 0, y = 180, w = kMax, h = kMax,
	        flags = kHAlignCenter + kVAlignTop,
	        font = {edwardian_medium, 30, Color(119, 182, 219)},
	        label = "#<outline color='000000' size=3>"..GetString(gDialogTable.level_pass).."</outline>",
	    },
	    Text {
	        name = "endlevel_goal",
	        x = 0, y = 234, w = 420, h = 33,
	        flags = kHAlignRight + kVAlignCenter,
	        font = {edwardian_medium, 22, BlackColor},
	        label = "endlevel_goal_score",
	    },
	    Text {
	        name = "endlevel_mastery",
	        x = 0, y = 267, w = 420, h = 33,
	        flags = kHAlignRight + kVAlignCenter,
	        font = {edwardian_medium, 22, BlackColor},
	        label = "endlevel_mastery_score",
	    },
	    Text {
	        name = "endlevel_today",
	        x = 0, y = 312, w = 420, h = 41,
	        flags = kHAlignRight + kVAlignCenter,
	        font = {edwardian_medium, 24, BlackColor},
	        label = "endlevel_today",
	    },
	    Text {
	        name = "endlevel_served",
	        x = 0, y = 374, w = 420, h = 25,
	        flags = kHAlignRight + kVAlignCenter,
	        font = {edwardian_medium, 20, BlackColor},
	        label = "endlevel_served",
	    },
	    Text {
	        name = "endlevel_lost",
	        x = 0, y = 404, w = 420, h = 25,
	        flags = kHAlignRight + kVAlignCenter,
	        font = {edwardian_medium, 20, BlackColor},
	        label = "endlevel_lost",
	    },
	    Text {
	        name = "endlevel_goal_amt",
	        x = 440, y = 234, w = 420, h = 33,
	        flags = kHAlignLeft + kVAlignCenter,
	        font = {edwardian_medium, 24, Color(108,146,76)},
	        label = "#$"..GetGoalScore(gDialogTable.level_num),
	    },
	    Text {
	        name = "endlevel_mastery_amt",
	        x = 440, y = 267, w = 420, h = 33,
	        flags = kHAlignLeft + kVAlignCenter,
	        font = {edwardian_medium, 24, Color(159,27,58)},
	        label = "#$"..GetMasteryScore(gDialogTable.level_num),
	    },
	    Text {
	        name = "endlevel_today_amt",
	        x = 440, y = 312, w = 420, h = 41,
	        flags = kHAlignLeft + kVAlignCenter,
	        font = {edwardian_medium, 30, BlackColor},
	        label = "#$"..GetManagedInt("current_level_total", 0),
	    },
	    Text {
	        name = "endlevel_served_amt",
	        x = 440, y = 374, w = 420, h = 25,
	        flags = kHAlignLeft + kVAlignCenter,
	        font = {edwardian_medium, 22, BlackColor},
	        label = "#"..GetManagedInt("served_this_level", 0),
	    },
	    Text {
	        name = "endlevel_lost_amt",
	        x = 440, y = 404, w = 420, h = 25,
	        flags = kHAlignLeft + kVAlignCenter,
	        font = {edwardian_medium, 22, BlackColor},
	        label = "#"..GetManagedInt("angry_this_level", 0),
	    },
	},
	RBounceWindow{
	    x = kCenter - 537, y = 600 - 238,
	    image = "ui/endlevel/trim_left",
        mask = "ui/endlevel/trim_left.mask",
	    targetposx = 0, targetposy = 600 - 238,
	    SetStyle(App_MenuButtonStyle),
	    alpha = true,
	    SetStyle(CSMMRight2ButtonStyle),
		Button{
			x = 3, y = 135, 
			hflip = true,
			Text{
			    x = 10, y = 0,
				w = kMax, h = kMax - 10,
				font = {edwardian_medium, 20, WhiteColor},
				flags = kHAlignCenter + kVAlignCenter,
				label = "app_quit",
			},
			command = 
				function()
				    if( GetCurrentGameMode() == 0 ) then
				        SetQuitting(true);
                        result = DisplayDialog{ "scripts/yesno.lua", body = "quit_game_body", header = "", width=390, height=230 };
	                    if(result == "yes") then
	                        --if( not closed ) then
                                --closed = true;
	                            HideNotification();
			                    PostMessage( CreateNamedMessage( kTintOff, "" ) );
			                    DoTransition( kBounceBack );
			                    DoTransition( kFadeToBlack );
			                    QuitToMainMenu();
				            --end
				        end
				        SetQuitting(false);
				    else
				        PostMessage( CreateNamedMessage( kTintOff, "" ) );
			            DoTransition( kBounceBack );
				        DoTransition( kFadeToBlack );
			            QuitToMainMenu();
				    end
				end
		},
	},
	RBounceWindow{
	    x = 800, y = 600 - 238,
	    image = "ui/endlevel/trim_left",
        mask = "ui/endlevel/trim_left.mask",
	    hflip = true,
	    targetposx = 800 - 137, targetposy = 600 - 238,
	    alpha = true,
	    SetStyle(CSMMRight2ButtonStyle),
	    Button{
	        name = "btn_continue",
			x = 15, y = 135,
			Text{
			    name = "txt_continue",
				w = kMax - 10, h = kMax - 10,
				font = {edwardian_medium, 20, WhiteColor},
				flags = kHAlignCenter + kVAlignCenter,
				label = "app_ok",
			},
			command = 
				function()
				    if( not closed ) then
                        closed = true;
				        HideNotification();
				        PostMessage( CreateNamedMessage( kTintOff, "" ) );
			            DoTransition( kBounceBack );
				        DoTransition( kFadeToBlack );
				        GotoNextLevel();
					end
				end
		},
	},
	RBounceWindow{
	    x = 141, y = 600,
	    targetposx = 141, targetposy = 445,
	    image = "ui/endlevel/trim_bottom",
	    mask = "ui/endlevel/trim_bottom.mask",
	    alpha = true,
	    
	    Text {
	        x = 0, y = 7, w = 167, h = 38,
	        flags = kHAlignRight + kVAlignCenter,
	        font = {edwardian_medium, 28, BlackColor},
	        label = "#Cash:",
	    },
	    
	    Text {
	        x = 35, y = 73, w = 460, h = 75,
	        name = "txt_extra_info",
	        font = {edwardian_medium, 14, BlackColor},
	        flags = kHAlignCenter + kVAlignCenter,
	        label = "#"..GetEndlevelText( gDialogTable.level_status ),
	    },
	    
	    --[[Bitmap{
		    x = 36, y = 45,
		    image = "anim/portraits/evangeline_small",
		},]]
	    
	    Text{
			font = {edwardian_medium,36,WhiteColor},
			x = 170, y = 4,
			w = 50, h = 50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "#$",
		},
	    VRegister{
	        x = 175, y = 20, w = 260, h = 38,
	        numDigits = 7,
            context = "endlevel",
			digit = {
			    font = {edwardian_medium, 25, WhiteColor},
			    x = 0,
			    y = 0,
			    w = 15,
			    h = 25,
			},
	    },
	    
	    Bitmap{
	        x = 0, y = 0,
	        image = "ui/endlevel/trim_bottom_highlight.png",
	    },
	},
}
InsideGame(false);

ShowNewAchievements(0);

if(GetCurrentGameMode() ~= 0) then
    SetLabel("endlevel_goal", GetString("endlevel_total"));
    SetLabel("endlevel_goal_amt", "$"..GetManagedInt("current_worth", 0));
    EnableWindow("endlevel_mastery", false);
    EnableWindow("endlevel_mastery_amt", false);
    SetLabel("endlevel_today", GetString("endlevel_time"));
    SetLabel("endlevel_today_amt", gDialogTable.time);
    EnableWindow("endlevel_lost", false);
    EnableWindow("endlevel_lost_amt", false);
    SetLabel("txt_continue", GetString("endlevel_tryagain"));
elseif( gDialogTable.level_pass == "endlevel_fail" ) then
    SetLabel("txt_continue", GetString("endlevel_tryagain"));
end